/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betterend.blocks.EternalPedestal;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.client.render.BeamRenderer;
import org.betterx.betterend.client.render.EndCrystalRenderer;
import org.betterx.betterend.client.render.EternalCrystalRenderer;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class PedestalItemRenderer<T extends PedestalBlockEntity>
implements BlockEntityRenderer<T> {
    public PedestalItemRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = blockEntity.m_58904_();
        if (world == null || ((PedestalBlockEntity)((Object)blockEntity)).m_7983_()) {
            return;
        }
        BlockState state = world.m_8055_(blockEntity.m_58899_());
        if (!(state.m_60734_() instanceof PedestalBlock)) {
            return;
        }
        ItemStack activeItem = ((PedestalBlockEntity)((Object)blockEntity)).m_8020_(0);
        matrices.m_85836_();
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel model = minecraft.m_91291_().m_174264_(activeItem, world, null, 0);
        Vector3f translate = model.m_7442_().f_111793_.f_111756_;
        PedestalBlock pedestal = (PedestalBlock)state.m_60734_();
        matrices.m_85837_((double)translate.x() + 0.5, (double)(translate.y() + pedestal.getHeight(state)), (double)translate.z() + 0.5);
        if (activeItem.m_41720_() instanceof BlockItem) {
            matrices.m_85841_(1.5f, 1.5f, 1.5f);
        } else {
            matrices.m_85841_(1.25f, 1.25f, 1.25f);
        }
        int age = PedestalItemRenderer.getGemAge();
        if (state.m_60713_(EndBlocks.ETERNAL_PEDESTAL) && ((Boolean)state.m_61143_((Property)EternalPedestal.ACTIVATED)).booleanValue()) {
            float[] colors = EternalCrystalRenderer.colors(age);
            int y = blockEntity.m_58899_().m_123342_();
            BeamRenderer.renderLightBeam(matrices, vertexConsumers, age, tickDelta, -y, 1024 - y, colors, 0.25f, 0.13f, 0.16f);
            float altitude = Mth.m_14031_((float)(((float)age + tickDelta) / 10.0f)) * 0.1f + 0.1f;
            matrices.m_85837_(0.0, (double)altitude, 0.0);
        }
        if (activeItem.m_41720_() == Items.f_42729_) {
            EndCrystalRenderer.render(age, 314, tickDelta, matrices, vertexConsumers, light);
        } else if (activeItem.m_41720_() == EndItems.ETERNAL_CRYSTAL) {
            EternalCrystalRenderer.render(age, tickDelta, matrices, vertexConsumers, light);
        } else {
            float rotation = ((float)age + tickDelta) / 25.0f + 6.0f;
            matrices.m_252781_(Axis.f_252436_.m_252961_(rotation));
            minecraft.m_91291_().m_115143_(activeItem, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, light, overlay, model);
        }
        matrices.m_85849_();
    }

    public static int getGemAge() {
        return (int)(Minecraft.m_91087_().f_91073_.m_46467_() % 314L);
    }
}

